<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

$conn = getDB();

// Get report data
$reports = [
    'daily_applications' => [],
    'payment_stats' => [],
    'admission_stats' => []
];

// Daily applications for the last 7 days
$query = "SELECT DATE(submitted_at) as date, COUNT(*) as count 
          FROM applications 
          WHERE submitted_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
          GROUP BY DATE(submitted_at) 
          ORDER BY date DESC";
$result = $conn->query($query);
while ($row = $result->fetch_assoc()) {
    $reports['daily_applications'][$row['date']] = $row['count'];
}

// Payment statistics
$query = "SELECT status, COUNT(*) as count FROM payments GROUP BY status";
$result = $conn->query($query);
while ($row = $result->fetch_assoc()) {
    $reports['payment_stats'][$row['status']] = $row['count'];
}

// Admission statistics by section
$query = "SELECT a.section, s.status, COUNT(*) as count 
          FROM applications a
          JOIN admission_status s ON a.application_id = s.application_id
          GROUP BY a.section, s.status";
$result = $conn->query($query);
while ($row = $result->fetch_assoc()) {
    $reports['admission_stats'][$row['section']][$row['status']] = $row['count'];
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <style>
        .report-card {
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            height: 100%;
        }
        .chart-container {
            height: 300px;
        }
    </style>
</head>
<body>
    <div class="admin-container d-flex">
        <!-- SIDEBAR PLACEHOLDER - COPY FROM YOUR EXISTING SIDEBAR -->
         <?php include'sidebar.php'; ?>
        
        <div class="main-content">
            <div class="container-fluid py-4">
                <h2 class="mb-4">System Reports</h2>
                
                <!-- Daily Applications Report -->
                <div class="card report-card mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Daily Applications (Last 7 Days)</h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="dailyApplicationsChart"></canvas>
                        </div>
                    </div>
                </div>
                
                <!-- Payment Status Report -->
                <div class="card report-card mb-4">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Payment Status Overview</h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="paymentStatusChart"></canvas>
                        </div>
                    </div>
                </div>
                
                <!-- Admission Statistics -->
                <div class="card report-card">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Admission Statistics by Section</h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="admissionStatsChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Daily Applications Chart
        const dailyCtx = document.getElementById('dailyApplicationsChart').getContext('2d');
        new Chart(dailyCtx, {
            type: 'bar',
            data: {
                labels: <?= json_encode(array_keys($reports['daily_applications'])) ?>,
                datasets: [{
                    label: 'Applications',
                    data: <?= json_encode(array_values($reports['daily_applications'])) ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.7)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });

        // Payment Status Chart
        const paymentCtx = document.getElementById('paymentStatusChart').getContext('2d');
        new Chart(paymentCtx, {
            type: 'pie',
            data: {
                labels: <?= json_encode(array_keys($reports['payment_stats'])) ?>,
                datasets: [{
                    data: <?= json_encode(array_values($reports['payment_stats'])) ?>,
                    backgroundColor: [
                        'rgba(75, 192, 192, 0.7)',
                        'rgba(255, 99, 132, 0.7)',
                        'rgba(255, 206, 86, 0.7)'
                    ],
                    borderWidth: 1
                }]
            }
        });

        // Admission Stats Chart
        const admissionCtx = document.getElementById('admissionStatsChart').getContext('2d');
        new Chart(admissionCtx, {
            type: 'bar',
            data: {
                labels: ['Primary', 'Junior'],
                datasets: [
                    {
                        label: 'Pending',
                        data: [
                            <?= $reports['admission_stats']['primary']['pending'] ?? 0 ?>,
                            <?= $reports['admission_stats']['junior']['pending'] ?? 0 ?>
                        ],
                        backgroundColor: 'rgba(255, 206, 86, 0.7)'
                    },
                    {
                        label: 'Accepted',
                        data: [
                            <?= $reports['admission_stats']['primary']['accepted'] ?? 0 ?>,
                            <?= $reports['admission_stats']['junior']['accepted'] ?? 0 ?>
                        ],
                        backgroundColor: 'rgba(75, 192, 192, 0.7)'
                    },
                    {
                        label: 'Rejected',
                        data: [
                            <?= $reports['admission_stats']['primary']['rejected'] ?? 0 ?>,
                            <?= $reports['admission_stats']['junior']['rejected'] ?? 0 ?>
                        ],
                        backgroundColor: 'rgba(255, 99, 132, 0.7)'
                    }
                ]
            },
            options: {
                responsive: true,
                scales: {
                    x: {
                        stacked: true,
                    },
                    y: {
                        stacked: true,
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>
</html>