<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Processing</title>
    <!-- Tailwind CSS CDN for basic styling -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- SweetAlert2 for better alerts -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- jQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <style>
        body {
            font-family: "Inter", sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f0f2f5;
        }
        .container {
            background-color: #ffffff;
            padding: 2rem;
            border-radius: 0.75rem; /* rounded-lg */
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05); /* shadow-xl */
            text-align: center;
            max-width: 28rem; /* max-w-md */
            width: 100%;
        }
        .spinner {
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-left-color: #3b82f6; /* blue-500 */
            border-radius: 50%;
            width: 3rem;
            height: 3rem;
            animation: spin 1s linear infinite;
            margin: 0 auto 1.5rem;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="spinner"></div>
        <h1 class="text-2xl font-bold text-gray-800 mb-2">Please wait...</h1>
        <p class="text-gray-600">Do not close this window. We are verifying your payment.</p>
    </div>

    <script>
        $(document).ready(function() {
            // Function to get URL parameters
            function getUrlParameter(name) {
                name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
                var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
                var results = regex.exec(location.search);
                return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
            }

            // Get the reference from the URL (Paystack appends it after redirect)
            const reference = getUrlParameter('reference');
            const trxref = getUrlParameter('trxref'); // Paystack might also send trxref

            if (reference) {
                // Make an AJAX call to your verify_payment.php API
                $.ajax({
                    url: '../api/verify_payment.php',
                    type: 'POST',
                    data: {
                        reference: reference,
                        trxref: trxref // Send both for compatibility
                    },
                    dataType: 'json', // Expect JSON response
                    success: function(result) {
                        if (result.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Payment Successful!',
                                text: 'Redirecting to your application form.',
                                showConfirmButton: false,
                                timer: 1500
                            }).then(() => {
                                window.location.href = result.redirect_url; // Redirect to application page
                            });
                        } else {
                            // Handle duplicate entry or other errors
                            let errorMessage = result.message || 'Payment verification failed.';
                            if (errorMessage.includes('Duplicate entry')) {
                                Swal.fire({
                                    icon: 'info',
                                    title: 'Payment Already Processed',
                                    text: 'This payment has already been processed. You can proceed to your application.',
                                    confirmButtonText: 'Go to Application'
                                }).then(() => {
                                    // Use the application page URL directly if it's a known path
                                    window.location.href = 'index.php';
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Payment Failed',
                                    text: errorMessage,
                                    footer: '<a href="payment.php" class="text-blue-500 hover:underline">Go back to Payment Page</a>'
                                });
                            }
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX error during verification:", status, error, xhr.responseText);
                        Swal.fire({
                            icon: 'error',
                            title: 'Network Error',
                            text: 'Could not connect to the verification server. Please try again.',
                            footer: '<a href="payment.php" class="text-blue-500 hover:underline">Go back to Payment Page</a>'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Payment Reference Missing',
                    text: 'Could not find payment reference in the URL. Please try again.',
                    footer: '<a href="payment.php" class="text-blue-500 hover:underline">Go back to Payment Page</a>'
                });
            }
        });
    </script>
</body>
</html>
