<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$paystack_secret_key = 'sk_live_534504e606b1588139d0ad821557c0bdd6e7ff0e'; // Replace with your key
$email = $_SESSION['email'];
$amount = 1500 * 100; // 5000 Naira in kobo
$reference = 'APP_' . uniqid(); // Unique reference

// Initialize Paystack transaction via API
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.paystack.co/transaction/initialize",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer " . $paystack_secret_key,
        "Content-Type: application/json"
    ],
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode([
        'email' => $email,
        'amount' => $amount,
        'reference' => $reference,
        // --- IMPORTANT CHANGE HERE ---
        // Change the callback_url to a frontend page that will handle the verification
        'callback_url' => 'https://portal.icolats.com.ng/pages/payment_callback_handler.php',
        'metadata' => ['user_id' => $_SESSION['user_id']] // Track user
    ])
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    die("cURL Error: " . $err);
}

$result = json_decode($response);
if ($result->status) {
    // Redirect to Paystack payment page
    header("Location: " . $result->data->authorization_url);
    exit;
} else {
    die("Paystack Error: " . $result->message);
}
?>
