<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Application Portal</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>

    <nav class="navbar navbar-expand-md navbar-light bg-light sticky-top shadow-sm d-md-none">
        <div class="container-fluid">
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarOffcanvas" aria-controls="sidebarOffcanvas" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <a class="navbar-brand ms-3 fw-bold" href="#">School Portal</a>
            </div>
    </nav>

    <div class="container-fluid">
        <div class="row flex-nowrap">
            <div class="col-auto col-md-3 col-xl-2 px-sm-2 px-0 bg-dark sidebar-desktop d-none d-md-block">
                <div class="d-flex flex-column align-items-center align-items-sm-start px-3 pt-2 text-white min-vh-100">
                    <h4 class="text-center py-3 text-white">School Portal</h4>
                    <ul class="nav nav-pills flex-column mb-sm-auto mb-0 align-items-center align-items-sm-start w-100" id="menu">
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle active" href="#" onclick="loadPage('application')">
                                <i class="fs-4 bi-house"></i> <span class="ms-1 d-none d-sm-inline">Application</span>
                            </a>
                        </li>
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle" href="#" onclick="loadPage('payment')">
                                <i class="fs-4 bi-credit-card"></i> <span class="ms-1 d-none d-sm-inline">Payment</span>
                            </a>
                        </li>
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle" href="#" onclick="loadPage('admission')">
                                <i class="fs-4 bi-file-earmark-check"></i> <span class="ms-1 d-none d-sm-inline">Admission Status</span>
                            </a>
                        </li>
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle" href="logout.php">
                                <i class="fs-4 bi-box-arrow-right"></i> <span class="ms-1 d-none d-sm-inline">Logout</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="offcanvas offcanvas-start bg-dark text-white" tabindex="-1" id="sidebarOffcanvas" aria-labelledby="sidebarOffcanvasLabel">
                <div class="offcanvas-header">
                    <h5 class="offcanvas-title" id="sidebarOffcanvasLabel">School Portal</h5>
                    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                </div>
                <div class="offcanvas-body">
                    <ul class="nav nav-pills flex-column mb-sm-auto mb-0 align-items-start w-100">
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle active" href="#" onclick="loadPage('application'); $('#sidebarOffcanvas').offcanvas('hide');">
                                <i class="fs-4 bi-house"></i> <span class="ms-1">Application</span>
                            </a>
                        </li>
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle" href="#" onclick="loadPage('payment'); $('#sidebarOffcanvas').offcanvas('hide');">
                                <i class="fs-4 bi-credit-card"></i> <span class="ms-1">Payment</span>
                            </a>
                        </li>
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle" href="#" onclick="loadPage('admission'); $('#sidebarOffcanvas').offcanvas('hide');">
                                <i class="fs-4 bi-file-earmark-check"></i> <span class="ms-1">Admission Status</span>
                            </a>
                        </li>
                        <li class="nav-item w-100">
                            <a class="nav-link text-white px-0 align-middle" href="logout.php">
                                <i class="fs-4 bi-box-arrow-right"></i> <span class="ms-1">Logout</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <main id="content" class="col py-3 px-4 mt-4 mt-md-0">
                </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://js.paystack.co/v1/inline.js"></script>
    <script src="../assets/js/app.js"></script>

    <script>
        $(document).ready(function() {
            // Initial load for the application page
            loadPage('application');

            // Handle active state for sidebar links
            $(document).on('click', '.nav-link', function() {
                $('.nav-link').removeClass('active');
                $(this).addClass('active');
            });
        });
    </script>
</body>
</html>
