<?php
session_start();
header('Content-Type: application/json');
require_once '../config/db.php';
$conn = getDB();

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$application_id = $_POST['application_id'];
if (isset($_FILES['admission_letter']) && $_FILES['admission_letter']['error'] == 0) {
    $ext = pathinfo($_FILES['admission_letter']['name'], PATHINFO_EXTENSION);
    $filename = 'letter_' . $application_id . '.' . $ext;
    move_uploaded_file($_FILES['admission_letter']['tmp_name'], '../uploads/' . $filename);

    $sql = "UPDATE admission_status SET admission_letter = ? WHERE application_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $filename, $application_id);
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Admission letter uploaded']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update letter']);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'No file uploaded']);
}
$conn->close();
?>