<?php
session_start();
header('Content-Type: application/json');
require_once '../config/db.php';
$conn = getDB();

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$application_id = $_POST['application_id'];
$score = $_POST['score'];

$sql = "UPDATE admission_status SET score = ? WHERE application_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $score, $application_id);
if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Score updated']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update score']);
}
$stmt->close();
$conn->close();
?>