<?php
session_start();
require_once '../config/db.php';
$conn = getDB();

if (!isset($_GET['application_id'])) {
    die('Invalid application ID');
}

$application_id = $_GET['application_id'];
$sql = "SELECT * FROM applications WHERE application_id = ? AND user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $application_id, $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
if ($app = $result->fetch_assoc()) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Application Slip</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body>
        <div class="container mt-5">
            <h2>Application Slip</h2>
            <p><strong>Application ID:</strong> <?php echo $app['application_id']; ?></p>
            <p><strong>Section:</strong> <?php echo ucfirst($app['section']); ?></p>
            <p><strong>First Name:</strong> <?php echo $app['first_name']; ?></p>
            <p><strong>Last Name:</strong> <?php echo $app['last_name']; ?></p>
            <p><strong>Age:</strong> <?php echo $app['age']; ?></p>
            <button onclick="window.print()" class="btn pay-button">Print</button>
        </div>
    </body>
    </html>
    <?php
} else {
    echo "Application not found.";
}
$stmt->close();
$conn->close();
?>