<?php
session_start();
header('Content-Type: text/html');
require_once '../config/db.php';

if (!isset($_SESSION['admin_id'])) {
    die('Unauthorized');
}

$conn = getDB();
$application_id = $_GET['application_id'];

$sql = "SELECT a.*, p.status AS payment_status, s.status AS admission_status, s.score, s.admission_letter
        FROM applications a 
        LEFT JOIN payments p ON a.application_id = p.application_id 
        LEFT JOIN admission_status s ON a.application_id = s.application_id
        WHERE a.application_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $application_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die('Application not found');
}

$app = $result->fetch_assoc();
$stmt->close();
$conn->close();
?>

<div class="row">
    <div class="col-md-6">
        <h5>Personal Information</h5>
        <table class="table table-sm">
            <tr>
                <th>Application ID</th>
                <td><?php echo $app['application_id']; ?></td>
            </tr>
            <tr>
                <th>Full Name</th>
                <td><?php echo htmlspecialchars($app['full_name']); ?></td>
            </tr>
            <tr>
                <th>Section</th>
                <td><?php echo ucfirst($app['section']); ?></td>
            </tr>
            <tr>
                <th>Gender</th>
                <td><?php echo $app['gender']; ?></td>
            </tr>
            <tr>
                <th>Date of Birth</th>
                <td><?php echo $app['dob']; ?></td>
            </tr>
            <tr>
                <th>Age</th>
                <td><?php echo $app['age']; ?></td>
            </tr>
            <tr>
                <th>LGA</th>
                <td><?php echo $app['lga']; ?></td>
            </tr>
            <tr>
                <th>State</th>
                <td><?php echo $app['state']; ?></td>
            </tr>
        </table>
        
        <h5 class="mt-4">Parent/Guardian Information</h5>
        <table class="table table-sm">
            <tr>
                <th>Name</th>
                <td><?php echo $app['parent_name']; ?></td>
            </tr>
            <tr>
                <th>Occupation</th>
                <td><?php echo $app['parent_occupation']; ?></td>
            </tr>
            <tr>
                <th>Phone</th>
                <td><?php echo $app['parent_phone']; ?></td>
            </tr>
            <tr>
                <th>Email</th>
                <td><?php echo $app['parent_email']; ?></td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h5>Academic Information</h5>
        <?php if ($app['section'] === 'junior'): ?>
        <table class="table table-sm">
            <tr>
                <th>Current School</th>
                <td><?php echo $app['current_school']; ?></td>
            </tr>
            <tr>
                <th>Current Class</th>
                <td><?php echo $app['current_class']; ?></td>
            </tr>
        </table>
        <?php endif; ?>
        
        <h5 class="mt-4">Medical Information</h5>
        <table class="table table-sm">
            <tr>
                <th>Health Status</th>
                <td><?php echo $app['health_status']; ?></td>
            </tr>
            <tr>
                <th>Disability</th>
                <td>
                    <?php echo $app['disability']; ?>
                    <?php if ($app['disability'] === 'OTHER' && $app['other_disability']): ?>
                        (<?php echo $app['other_disability']; ?>)
                    <?php endif; ?>
                </td>
            </tr>
        </table>


<h5 class="mt-4">Documents</h5>
<div class="d-flex flex-wrap gap-2">
    <?php if ($app['photograph']): ?>
    <a href="../uploads/<?php echo $app['photograph']; ?>" 
       class="btn btn-sm btn-outline-primary" 
       target="_blank"
       onclick="return openDocumentViewer(this.href, 'image')">
        <i class="bi bi-image"></i> View Photograph
    </a>
    <?php endif; ?>
    
    <?php if ($app['birth_cert']): ?>
    <a href="../uploads/<?php echo $app['birth_cert']; ?>" 
       class="btn btn-sm btn-outline-primary" 
       target="_blank"
       onclick="return openDocumentViewer(this.href, 'document')">
        <i class="bi bi-file-text"></i> View Birth Certificate
    </a>
    <?php endif; ?>
    
    <?php if ($app['lga_cert']): ?>
    <a href="../uploads/<?php echo $app['lga_cert']; ?>" 
       class="btn btn-sm btn-outline-primary" 
       target="_blank"
       onclick="return openDocumentViewer(this.href, 'document')">
        <i class="bi bi-file-text"></i> View LGA Certificate
    </a>
    <?php endif; ?>
    
    <?php if ($app['primary_cert']): ?>
    <a href="../uploads/<?php echo $app['primary_cert']; ?>" 
       class="btn btn-sm btn-outline-primary" 
       target="_blank"
       onclick="return openDocumentViewer(this.href, 'document')">
        <i class="bi bi-file-text"></i> View Primary Certificate
    </a>
    <?php endif; ?>
    
    <?php if ($app['admission_letter']): ?>
    <a href="../uploads/<?php echo $app['admission_letter']; ?>" 
       class="btn btn-sm btn-outline-success" 
       target="_blank"
       onclick="return openDocumentViewer(this.href, 'document')">
        <i class="bi bi-file-earmark-pdf"></i> View Admission Letter
    </a>
    <?php endif; ?>
</div>


    </div>
</div>

<script>
function openDocumentViewer(url, type) {
    // Open in a new tab for viewing
    window.open(url, '_blank');
    return false; // Prevent default behavior
}
</script>