    $(document).ready(function() {
        // Load default page
        loadPage('application');

        // Handle form submission for application
        $(document).on('submit', '#admissionForm', function(e) { // Changed to #admissionForm
            e.preventDefault();
            var formData = new FormData(this);
            
            // Show loading state
            var submitBtn = $(this).find('button[type="submit"]');
            submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Processing...');
            
            $.ajax({
                url: '../api/application.php',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: 'Application submitted successfully',
                            confirmButtonText: 'Continue'
                        }).then(() => {
                            // Only redirect on actual success
                            window.location.href = 'application.php';
                        });
                    } else {
                        // Show error message from API response
                        Swal.fire({
                            icon: 'error', // Changed to error icon for general failure
                            title: 'Error',
                            text: response.message || 'Submission failed'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX error for application.php:", status, error, xhr.responseText);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred: ' + (xhr.responseText || error)
                    });
                },
                complete: function() {
                    submitBtn.prop('disabled', false).html('<i class="bi bi-send"></i> Submit Application');
                }
            });
        });

        // Handle payment (keep this as is from previous correct version)
        $(document).on('click', '#payButton', function() {
            let email = $(this).data('email');
            if (!email || !email.includes('@')) {
                alert('Invalid or missing email. Please log in again.');
                return;
            }
            let amount = 5000; // Example: 5000 NGN
            console.log('Paystack params:', {
                key: 'sk_live_534504e606b1588139d0ad821557c0bdd6e7ff0e',
                email: email,
                amount: amount * 100
            });
            let handler = PaystackPop.setup({
                key: 'sk_live_534504e606b1588139d0ad821557c0bdd6e7ff0e', // Replace with your valid Paystack public key
                email: email,
                amount: amount * 100, // Convert to kobo
                ref: 'APP' + Math.floor((Math.random() * 1000000000) + 1),
                onClose: function() {
                    alert('Payment window closed.');
                },
                callback: function(response) {
                    $.ajax({
                        url: '../api/verify_payment.php',
                        type: 'POST',
                        data: { 
                            reference: response.reference,
                            trxref: response.reference // send both for compatibility
                        },
                        dataType: 'json', // Ensure jQuery parses JSON automatically
                        success: function(res) {
                            // 'res' is already an object
                            if (res.success) {
                                window.location.href = res.redirect_url;
                            } else {
                                if (res.message && res.message.includes('Duplicate entry')) {
                                    Swal.fire({
                                        icon: 'info',
                                        title: 'Payment Already Processed',
                                        text: 'This payment has already been processed. You can proceed to your application.',
                                        confirmButtonText: 'Go to Application'
                                    }).then(() => {
                                        window.location.href = '/baffffa/school-portal/pages/application.php';
                                    });
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Payment verification failed',
                                        text: res.message || 'Payment verification failed.',
                                        footer: '<a href="pages/payment.php" class="btn btn-primary mt-2">Go back to Payment</a>'
                                    });
                                }
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error("AJAX error for verify_payment.php:", status, error, xhr.responseText);
                            Swal.fire({
                                icon: 'error',
                                title: 'Network Error',
                                text: 'Could not connect to the verification server. Please try again.',
                                footer: '<a href="pages/payment.php" class="btn btn-primary mt-2">Go back to Payment</a>'
                            });
                        }
                    });
                }
            });
            handler.openIframe();
        });
    });

    function loadPage(page) {
        $.ajax({
            url: '../pages/' + page + '.php',
            type: 'GET',
            success: function(data) {
                $('#content').html(data);
            },
            error: function(xhr, status, error) {
                console.error("AJAX error loading page " + page + ".php:", status, error, xhr.responseText);
                $('#content').html('<div class="alert alert-danger">Error loading page: ' + page + '. Please try again.</div>');
            }
        });
    }
    